<?php

/*
  ini_set('xdebug.var_display_max_depth','10');
  ini_set('display_errors','1');
  ini_set('display_startup_errors','1');
  error_reporting (E_ALL);
*/

  require("myumbc_xml.php");
  $group = "doit";
  
  if ($_GET["id"]) {
    $news_item = parse_xml($group, "newsitem_" . $_GET["id"], "");
  } else {
    $news = parse_xml($group, "news", "?page=1&page_size=5&mode=recent");
  }
?>

<html>

<head>
  <title>News Page</title>
</head>

<body>
<?php if (isset($news_item)) { ?>
  <a href="?">Back</a>
  <div id="news_item">
    <h3><?= $news_item["title"] ?></h3>
    <p>Tagline: <?= $news_item["tagline"] ?></p>
    <p>Posted At: <?= $news_item["posted_at"] ?></p>
    <p>Body: <?= $news_item["body"] ?></p>
    <?php if (isset($news_item["thumbnail"]["large"])) { ?>
      <p>Thumbnail: <img src=<?= $news_item["thumbnail"]["large"] ?> /> </p>
    <?php } ?>
    <p>Avatar: <img src=<?= $news_item["avatar_url"] ?> /></p>
    <p>Group: <a href=<?= $news_item["group_url"] ?>><?= $news_item["group"] ?></a></p>
    <p>Sponsor: <?= $news_item["sponsor"] ?></p>
    <p>Website: <?= $news_item["website"] ?></p>
    <?php if (isset($new_item["attachment_url"])) { ?>
      <p>Attachment Kind: <?= $news_item["attachment_kind"] ?></p>
      <p>Attachment URL: <a href="<?= $news_item["attachment_url"] ?>">URL</a></p>
    <?php } ?>
    <?php if (isset($news_item["tags"])) { ?>
      <p>Tags:</p>
      <ul>
        <?php foreach ($news_item["tags"] as $tag) { ?>
          <li><?= $tag ?></li>
        <?php } ?>
      </ul>
    <?php } ?>
    <?php if (isset($news_item["audiences"])) { ?>
      <p>Audiences:</p>
      <ul>
        <?php foreach ($news_item["audiences"] as $audience) { ?>
          <li><?= $audience ?></li>
        <?php } ?>
      </ul>
    <?php } ?>
    <?php if (isset($news_item["topics"])) { ?>
      <p>Topics:</p>
      <ul>
        <?php foreach ($news_item["topics"] as $topic) { ?>
          <li><?= $topic ?></li>
        <?php } ?>
      </ul>
    <?php } ?>
    <p>Paw Count: <?= $news_item["paw_count"] ?></p>
    <p>Comment Count: <?= $news_item["comment_count"] ?></p>
    
  </div>
<?php } else if ($news) { ?>
  <div id="news">
    <h3>Recent News</h3>
    <ul>
    <?php while(list($key,$val) = each($news)): ?>
      <li class='item-<?= $key ?>'>
        <div class="title"><a href="?id=<?= $news[$key]["id"] ?>"><?= $news[$key]["title"] ?></a></div>
        <div class="title">View in myUMBC:<a href="http://my.umbc.edu/groups/<?= $group ?>/news/<?= $news[$key]["id"] ?>">http://my.umbc.edu/groups/<?= $group ?>/news/<?= $news[$key]["id"] ?></a></div>
      </li>
    <?php endwhile; ?>
    </ul>
  </div>
<?php } else { ?>
<!-- Content when no news is being pulled through myUMBC -->
<?php } ?>
</body>

</html>